package coreservlets.filters;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Filtr przeksztaca kade danie wskazane w konfiguracji jako
 *  podlegajce przechwyceniu w bezporednie danie klienta.
 *  Zapobiega to popenianiu przez programistw bdu polegajcego na 
 *  dynamicznym przekierowaniu klienta do zabezpieczonego
 *  zasobu, co pozwala na obejcie zabezpieczenia deklaratywnego.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class SecurityHolePlugFilter implements Filter {
  public void doFilter(ServletRequest request,
                       ServletResponse response,
                       FilterChain chain)
      throws ServletException, IOException {
	HttpServletRequest req = (HttpServletRequest) request;
    HttpServletResponse res = (HttpServletResponse) response;
    res.sendRedirect(req.getRequestURI());
  }

  public void init(FilterConfig config)
      throws ServletException {
  }
  
  public void destroy() {}
}
